% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GIFT_taxonomy.R
\name{GIFT_taxonomy}
\alias{GIFT_taxonomy}
\title{Taxonomy of GIFT}
\usage{
GIFT_taxonomy(
  GIFT_version = "latest",
  api = "https://gift.uni-goettingen.de/api/extended/"
)
}
\arguments{
\item{GIFT_version}{character string defining the version of the GIFT
database to use. The function retrieves by default the \code{latest} stable
version. If set to \code{beta}, the most up-to-date version which is still
subject to changes and edits is used.}

\item{api}{character string defining from which API the data will be
retrieved.}
}
\value{
A data frame with 6 columns.
}
\description{
Retrieves the taxonomy of GIFT.
}
\details{
Here is what each column refers to:

\emph{taxon_ID} - the identification number of each taxonomic entry.\cr
\emph{taxon_name} - names describing taxa.\cr
\emph{taxon_name} - author name for a given taxon.\cr
\emph{taxon_lvl} - splits every taxon in genus, family, order or
superior orders. Taxonomy is a linear sequence of left and right borders
for each taxon. This is nested, for example left and right borders of a
genus would fall between the left and right borders of the corresponding
family. \cr
\emph{lft} - left border of one taxon in the taxonomic sequence.\cr
\emph{rgt} - right border of one taxon in the taxonomic sequence.\cr
}
\examples{
\donttest{
ex <- GIFT_taxonomy()
}

}
\references{
\if{html}{\out{<div class="sourceCode">}}\preformatted{ Denelle, P., Weigelt, P., & Kreft, H. (2023). GIFT—An R package to
 access the Global Inventory of Floras and Traits. Methods in Ecology
 and Evolution, 14, 2738-2748.
 https://doi.org/10.1111/2041-210X.14213

 Weigelt, P, König, C, Kreft, H. GIFT – A Global Inventory of Floras and
 Traits for macroecology and biogeography. J Biogeogr. 2020; 47: 16– 43.
 https://doi.org/10.1111/jbi.13623
}\if{html}{\out{</div>}}
}
\seealso{
\code{\link[=GIFT_checklists]{GIFT_checklists()}}
}
