% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsgp.functions.R
\name{nsgprPredict}
\alias{nsgprPredict}
\title{NSGP predicion given a vector of hyperparameters}
\usage{
nsgprPredict(
  hp,
  response,
  input,
  input.new,
  noiseFreePred = F,
  nBasis = nBasis,
  corrModel = corrModel,
  gamma = gamma,
  nu = nu,
  cyclic = cyclic,
  whichTau = whichTau
)
}
\arguments{
\item{hp}{Vector of hyperparameters estimated by function nsgpr.}

\item{response}{Response variable. This should be a (n x nSamples) matrix
where each column is a realisation}

\item{input}{List of Q input variables (see Details).}

\item{input.new}{List of Q test set input variables.}

\item{noiseFreePred}{Logical.  If TRUE, predictions will be noise-free.}

\item{nBasis}{Number of B-spline basis functions in each coordinate direction
along which parameters change.}

\item{corrModel}{Correlation function specification used for g(.). It can be
either "pow.ex" or "matern".}

\item{gamma}{Power parameter used in powered exponential kernel function. It
must be 0<gamma<=2.}

\item{nu}{Smoothness parameter of the Matern class. It must be a positive
value.}

\item{cyclic}{Logical vector of dimension Q which defines which covariates
are cyclic (periodic). For example, if basis functions should be cyclic
only in the first coordinate direction, then cyclic=c(T,F). cyclic must
have the same dimension of whichTau. If cyclic is TRUE for some coordinate
direction, then cyclic B-spline functions will be used and the varying
parameters (and their first two derivatives) will match at the boundaries
of that coordinate direction.}

\item{whichTau}{Logical vector of dimension Q identifying which input
coordinates the parameters are function of. For example, if Q=2 and
parameters change only with respect to the first coordinate, then we set
whichTau=c(T,F).}
}
\value{
A list containing  \describe{ 
\item{pred.mean}{Mean of predictions for the test set.}
\item{pred.sd}{Standard deviation of predictions for the test set.}
\item{noiseFreePred}{Logical. If TRUE, predictions are noise-free.}
}
}
\description{
NSGP predicion given a vector of hyperparameters
}
\examples{
## See examples in vignette:
# vignette("nsgpr", package = "GPFDA")
}
\references{
Konzen, E., Shi, J. Q. and Wang, Z. (2020) "Modeling
  Function-Valued Processes with Nonseparable and/or Nonstationary Covariance
  Structure" <arXiv:1903.09981>.
}
