% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsgp.functions.R
\name{nsgpCovMat}
\alias{nsgpCovMat}
\title{Calculate a NSGP covariance matrix given a vector of hyperparameters}
\usage{
nsgpCovMat(
  hp,
  input,
  inputSubsetIdx = NULL,
  nBasis = 5,
  corrModel = corrModel,
  gamma = NULL,
  nu = NULL,
  cyclic = NULL,
  whichTau = NULL,
  calcCov = T
)
}
\arguments{
\item{hp}{Vector of hyperparameters estimated by function nsgpr.}

\item{input}{List of Q input variables (see Details).}

\item{inputSubsetIdx}{A list identifying a subset of the input values to be
used in the estimation (see Details).}

\item{nBasis}{Number of B-spline basis functions in each coordinate direction
along which parameters change.}

\item{corrModel}{Correlation function specification used for g(.). It can be
either "pow.ex" or "matern".}

\item{gamma}{Power parameter used in powered exponential kernel function. It
must be 0<gamma<=2.}

\item{nu}{Smoothness parameter of the Matern class. It must be a positive
value.}

\item{cyclic}{Logical vector of dimension Q which defines which covariates
are cyclic (periodic). For example, if basis functions should be cyclic
only in the first coordinate direction, then cyclic=c(T,F). cyclic must
have the same dimension of whichTau. If cyclic is TRUE for some coordinate
direction, then cyclic B-spline functions will be used and the varying
parameters (and their first two derivatives) will match at the boundaries
of that coordinate direction.}

\item{whichTau}{Logical vector of dimension Q identifying which input
coordinates the parameters are function of. For example, if Q=2 and
parameters change only with respect to the first coordinate, then we set
whichTau=c(T,F).}

\item{calcCov}{Logical. Calculate covariance matrix or not. If FALSE, time or
spatially-varying parameters are still provided.}
}
\value{
A list containing  \describe{ 
\item{Cov}{Covariance matrix}
\item{vareps}{Noise variance}
\item{As_perTau}{List of varying anisotropy matrix over the input space}
\item{sig2_perTau}{Vector of signal variance over the input space}
}
}
\description{
Calculate a NSGP covariance matrix given a vector of hyperparameters
}
\examples{
## See examples in vignette:
# vignette("nsgpr", package = "GPFDA")
}
\references{
Konzen, E., Shi, J. Q. and Wang, Z. (2020) "Modeling
  Function-Valued Processes with Nonseparable and/or Nonstationary Covariance
  Structure" <arXiv:1903.09981>.
}
