% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpfr.functions6.R
\name{gpfrPredict}
\alias{gpfrPredict}
\title{Prediction of GPFR model}
\usage{
gpfrPredict(
  train,
  testInputGP,
  testTime = NULL,
  uReg = NULL,
  fxReg = NULL,
  gpReg = NULL,
  GPpredict = TRUE
)
}
\arguments{
\item{train}{An object of class 'gpfr' obtained by the the 'gpfr' function.}

\item{testInputGP}{Test input data for the GP prediction. It must be a numeric 
vector, a matrix or an 'fd' object.}

\item{testTime}{Test time points for prediction. If NULL, default settings
will be applied.}

\item{uReg}{Scalar covariates data of a new batch for the FR model.}

\item{fxReg}{Functional covariates data of a new batch for the FR model.}

\item{gpReg}{Input data for the GP part used for Type I prediction. It must
be a list of three items. The names of the items must be 'response',
'input', and 'time'. The item 'response' is the observed response for a new
batch; 'input' is the observed functional covariates for a new
batch,;'time' is the observed time for the previous two. If NULL (default),
Type II prediction is carried out.}

\item{GPpredict}{Logical. If TRUE (default), GPFR prediction is carried out;
otherwise only predictions based on the FR model is carried out.}
}
\value{
A list containing: \describe{ \item{ypred.mean}{The mean values of
  the prediction.} \item{ypred.sd}{The standard deviation of the
  predictions.} \item{predictionType}{Prediction type if  GPFR prediction is
  carried out.} \item{train}{All items trained by 'gpfr'.} }
}
\description{
Make predictions for test input data based on the GPFR model learnt by the
'gpfr' function. Both Type I and Type II predictions can be made.
}
\details{
If 'gpReg' is provided, then Type I prediction is made. Otherwise,
  Type II prediction is made.
}
\examples{
## See examples in vignette:
# vignette("gpfr", package = "GPFDA")
}
\references{
\itemize{ \item Ramsay, J., and Silverman, B. W. (2006),
  ``Functional Data Analysis'', 2nd ed., Springer, New York. \item Shi, J.
  Q., and Choi, T. (2011), ``Gaussian Process Regression Analysis for
  Functional Data'', CRC Press. }
}
