% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/top.alex.waterfall.plots.R
\name{top.alex.waterfall.plots}
\alias{top.alex.waterfall.plots}
\title{Waterfall Plots for Lesion and Expression Data of Top Significant Genes}
\usage{
top.alex.waterfall.plots(out.dir, alex.data, alex.kw.results, q, lsn.data)
}
\arguments{
\item{out.dir}{Path to the folder where the waterfall plots of selected genes based on the specified q value of the KW results table will be added.}

\item{alex.data}{output of the alex.prep.lsn.expr function. It's a list of three data tables that include "row.mtch", "alex.expr" with expression data, "alex.lsn" with lesion data. Rows of alex.expr, and "alex.lsn" matrices are ordered by gene ensembl IDs and columns are ordered by patient ID.}

\item{alex.kw.results}{ALEX Kruskal-Wallis test results (output of the KW.hit.express function).}

\item{q}{Maximum allowed KW q-value threshold for a gene to be plotted based on the output of the KW.hit.express function.}

\item{lsn.data}{Lesion data in a GRIN compatible format.}
}
\value{
Function will return waterfall plots for top significant genes in the KW results table.
}
\description{
Function return waterfall plots for top significant genes in the KW results table based on the specified q value.
}
\details{
Function will return waterfall plots for top significant genes in the KW results table based on the user specified q-value threshold of the KW test.The plots will be added to the user specified outdir folder.
}
\examples{
data(expr.data)
data(lesion.data)
data(hg19.gene.annotation)

# prepare expression, lesion data and return the set of genes with both types of data available
# ordered by gene IDs in rows and patient IDs in columns:
alex.data=alex.prep.lsn.expr(expr.data, lesion.data,
                             hg19.gene.annotation, min.expr=5,
                              min.pts.lsn=5)

# run KW test for association between lesion groups and expression level of the same gene:
alex.kw.results=KW.hit.express(alex.data, hg19.gene.annotation, min.grp.size=5)

# return waterfall plots for a list of top significant genes to a pre-specified folder:
dir.create(resultsFolder <- file.path(tempdir(), "temp.out"))

waterfall.plts=top.alex.waterfall.plots(out.dir=resultsFolder,
                                        alex.data, alex.kw.results,
                                        1e-15, lesion.data)

unlink(resultsFolder, recursive = TRUE)
}
\references{
Cao, X., Elsayed, A. H., & Pounds, S. B. (2023). Statistical Methods Inspired by Challenges in Pediatric Cancer Multi-omics.
}
\seealso{
\code{\link[=alex.prep.lsn.expr]{alex.prep.lsn.expr()}}, \code{\link[=KW.hit.express]{KW.hit.express()}}, \code{\link[=alex.waterfall.prep]{alex.waterfall.prep()}}, \code{\link[=alex.waterfall.plot]{alex.waterfall.plot()}}
}
\author{
{Abdelrahman Elsayed \email{abdelrahman.elsayed@stjude.org} and Stanley Pounds \email{stanley.pounds@stjude.org}}
}
