% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workbench.R
\name{addRegressor}
\alias{addRegressor}
\title{Add an extra regressor to a Workbench}
\usage{
addRegressor(wb, regressor, regressor.name = regressor, ...)
}
\arguments{
\item{wb}{the GROAN.Workbench instance to be updated}

\item{regressor}{regressor function}

\item{regressor.name}{string that will be used in reports. Keep in mind that when deciding names.}

\item{...}{extra parameters are passed to the regressor function}
}
\value{
an updated instance of the original GROAN.Workbench
}
\description{
This function adds a regressor to an existing \link[=createWorkbench]{GROAN.Workbench} object.
}
\examples{
#creating a Workbench with all default arguments
wb = createWorkbench()
#adding a second regressor
wb = addRegressor(wb, regressor = phenoRegressor.dummy, regressor.name = 'dummy')

\dontrun{
#trying to add again a regressor with the same name would result in a naming conflict error
wb = addRegressor(wb, regressor = phenoRegressor.dummy, regressor.name = 'dummy')}
}
\seealso{
\link{createWorkbench} \link{GROAN.run}
}
