% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{write_gmt}
\alias{write_gmt}
\title{write_gmt}
\usage{
write_gmt(gsc, filename)
}
\arguments{
\item{gsc}{A GSC (gene set collection) as a named list of character vectors of gene symbols, where
the names of the list items correspond to gene set identifiers.}

\item{filename}{An output file name.}
}
\value{
Currently returns a NULL value, invisibly.
}
\description{
Takes a gene set collection (as a named list of vectors of genes), and a filename, and writes GMT format.
Right now, keeping this private.
}
\details{
The function checks to see that the gsc argument is in fact a list of character vectors. If not,
it fails.
}
\examples{
library(GSNA)
gmtfile <- tempfile()
Bai_gsc.GSC <- tmod2gsc( Bai_gsc.tmod )
write_gmt( gsc = Bai_gsc.GSC, filename = gmtfile )

}
