% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gwalkr.R
\name{gwalkr}
\alias{gwalkr}
\title{Create GWalkR Interface in "Viewer"}
\usage{
gwalkr(
  data,
  lang = "en",
  dark = "light",
  columnSpecs = list(),
  visConfig = NULL,
  visConfigFile = NULL,
  toolbarExclude = list(),
  kernelComputation = FALSE
)
}
\arguments{
\item{data}{A data frame to be visualized in the GWalkR. The data frame should not be empty.}

\item{lang}{A character string specifying the language for the widget. Possible values are "en" (default), "ja", "zh".}

\item{dark}{A character string specifying the dark mode preference. Possible values are "light" (default), "dark", "media".}

\item{columnSpecs}{An optional list of lists to manually specify the types of some columns in the data frame.
Each top level element in the list corresponds to a column, and the list assigned to each column should have
two elements: \code{analyticalType} and \code{semanticType}. \code{analyticalType} can
only be one of "measure" or "dimension". \code{semanticType} can only be one of
"quantitative", "temporal", "nominal" or "ordinal". For example:
\code{list(
  "gender" = list(analyticalType = "dimension", semanticType = "nominal"),
  "age" = list(analyticalType = "measure", semanticType = "quantitative")
)}}

\item{visConfig}{An optional config string to reproduce your chart. You can copy the string by clicking "export config" button on the GWalkR interface.}

\item{visConfigFile}{An optional config file path to reproduce your chart. You can download the file by clicking "export config" button then "download" button on the GWalkR interface.}

\item{toolbarExclude}{An optional list of strings to exclude the tools from toolbar UI. However, Kanaries brand info is not allowed to be removed or changed unless you are granted with special permission.}

\item{kernelComputation}{An optional boolean to enable the kernel mode computation which is much more efficient. Default is FALSE.}
}
\value{
An \code{htmlwidget} object that can be rendered in R environments
}
\description{
Use this function to create a GWalkR interface from a given data frame in your "Viewer" window, and start your data exploration! Please make sure the width and the height of your "Viewer" window are large enough.
}
\examples{
data(mtcars)
gwalkr(mtcars)

}
