% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gwl_bw_estimation.R
\name{gwl_bw_estimation}
\alias{gwl_bw_estimation}
\title{Bandwidth estimation for Geographically Weighted Lasso}
\usage{
gwl_bw_estimation(
  x.var,
  y.var,
  dist.mat,
  adaptive = TRUE,
  adptbwd.thresh = 0.1,
  kernel = "bisquare",
  alpha = 1,
  progress = TRUE,
  nbw = 100,
  nfolds = 5
)
}
\arguments{
\item{x.var}{input matrix, of dimension nobs x nvars; each row is an observation vector. \code{x} should have 2 or more columns.}

\item{y.var}{response variable for the lasso}

\item{dist.mat}{a distance matrix. can be generated by \code{\link[=compute_distance_matrix]{compute_distance_matrix()}}}

\item{adaptive}{TRUE or FALSE Whether to perform an adaptive bandwidth search or not. A fixed bandwidth means that than samples are selected if they fit a determined fixed radius around a location.
in a aptative bandwidth , the radius around a location varies to gather a fixed number of samples around the investigated location}

\item{adptbwd.thresh}{the lowest fraction of samples to take into account for local regression. Must be 0 < \code{adptbwd.thresh} < 1}

\item{kernel}{the geographical kernel shape to compute the weight. passed to \code{\link[GWmodel:gw.weight]{GWmodel::gw.weight()}}
Can be \code{gaussian}, \code{exponential}, \code{bisquare}, \code{tricube}, \code{boxcar}}

\item{alpha}{the elasticnet mixing parameter. set 1 for lasso, 0 for ridge. see \code{\link[glmnet:glmnet]{glmnet::glmnet()}}}

\item{progress}{if TRUE, print a progress bar}

\item{nbw}{the number of bandwidth to test}

\item{nfolds}{the number f folds for the glmnet cross validation}
}
\value{
a \code{gwlest} object. It is a list with \code{rmspe} (the RMSPE of the model with the associated badwidth), \code{NA} (the number of NA in the dataset), \code{bw} (the optimal bandwidth), \code{bwd.vec} (the vector of tested bandwidth)
}
\description{
This function performs a bruteforce selection of the optimal bandwidth for the selected kernel to perform a geographically weighted lasso.
The user should be aware that this function could be really long to run depending of the settings.
We recommend starting with \code{nbw = 5} and \code{nfolds = 5} at first to ensure that the function is running properly and producing the desired output.
}
\examples{

predictors <- matrix(data = rnorm(2500), 50,50)
y_value <- sample(1:1000, 50)
coords <- data.frame("Lat" = rnorm(50), "Long" = rnorm(50))
distance_matrix <- compute_distance_matrix(coords)

\donttest{
  myst.est <- gwl_bw_estimation(x.var = predictors, 
                                y.var = y_value,
                                dist.mat = distance_matrix,
                                adaptive = TRUE,
                                adptbwd.thresh = 0.5,
                                kernel = "bisquare",
                                alpha = 1,
                                progress = TRUE,
                                n=10,
                                nfolds = 5)
  
  
  myst.est
 } 

}
\references{
A. Comber and P. Harris. \emph{Geographically weighted elastic net logistic regression (2018).
Journal of Geographical Systems, vol. 20, no. 4, pages 317–341}.
\doi{10.1007/s10109-018-0280-7}.\cr
}
