% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compiled_code_gamabiomd.R
\name{expand_accession_ranges}
\alias{expand_accession_ranges}
\title{This function expands accession number ranges, creating a data frame with sample and accession numbers.}
\usage{
expand_accession_ranges(accession_ranges)
}
\arguments{
\item{accession_ranges}{A named list where each element represents an accession range.
The names of the list elements should correspond to sample names.}
}
\value{
A data frame with columns 'sample' and 'accession'.
}
\description{
This function expands accession number ranges, creating a data frame with sample and accession numbers.
}
\examples{
# Example of defining accession number ranges.
accession_ranges <- list(
  SRU1 = "AJ240966 to AJ240970",
  STU2 = "AB015240 to AB015250",
  WRU8 = c("AF245628", "AF353208 to AF353210"),
  WPU13 = "L11934 to L11940",
  INU20 = c("AF277467 to AF277470", "AF333080 to AF333086")
)

# Use the function to expand accession ranges
sam_acc <- expand_accession_ranges(accession_ranges)
print(sam_acc)
}
