% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EstHMM1d.R
\name{EstHMM1d}
\alias{EstHMM1d}
\title{Estimation of a univariate Gaussian Hidden Markov Model (HMM)}
\usage{
EstHMM1d(y, reg, max_iter = 10000, prec = 1e-04)
}
\arguments{
\item{y}{(nx1) vector of data}

\item{reg}{number of regimes}

\item{max_iter}{maximum number of iterations of the EM algorithm; suggestion 10 000}

\item{prec}{precision (stopping criteria); suggestion 0.0001.}
}
\value{
\item{mu}{estimated mean for each regime}

\item{sigma}{stimated standard deviation for each regime}

\item{Q}{(reg x reg) estimated transition matrix}

\item{eta}{(n x reg) probabilities of being in regime k at time t given observations up to time t}

\item{lambda}{(n x reg) probabilities of being in regime k at time t given all observations}

\item{cvm}{Cramér-von Mises statistic for the goodness-of-fit test}

\item{W}{Pseudo-observations that should be uniformly distributed under the null hypothesis of a Gaussian HMM}

\item{LL}{Log-likelihood}
}
\description{
This function estimates parameters (mu, sigma, Q) of a univariate Hidden Markov Model.
It computes also the probability of being in each regime, given the past observations (eta)
and the whole series (lambda). The conditional distribution given past observations is applied to
obtains pseudo-observations W that should be uniformly distributed under the null hypothesis.
A Cramér-von Mises test statistic is then computed.
}
\examples{
Q <- matrix(c(0.8, 0.3, 0.2, 0.7),2,2); mu <- c(-0.3 ,0.7) ; sigma <- c(0.15,0.05)
data <- Sim.HMM.Gaussian.1d(mu,sigma,Q,eta0=1,100)$x
est <- EstHMM1d(data, 2, max_iter=10000, prec=0.0001)

}
\references{
Chapter 10.2 of B. Rémillard (2013). Statistical Methods for Financial Engineering,
Chapman and Hall/CRC Financial Mathematics Series, Taylor & Francis.
}
\author{
Bouchra R Nasri  and Bruno N Rémillard, January 31, 2019
}
