% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sim.HMM.Gaussian.1d.R
\name{Sim.HMM.Gaussian.1d}
\alias{Sim.HMM.Gaussian.1d}
\title{Simulation of a univariate Gaussian Hidden Markov Model (HMM)}
\usage{
Sim.HMM.Gaussian.1d(mu, sigma, Q, eta0, n)
}
\arguments{
\item{mu}{vector of means for each regime (r x 1);}

\item{sigma}{vector of standard deviations for each regime (r x 1);}

\item{Q}{Transition probality matrix (r x r);}

\item{eta0}{Initial value for the regime;}

\item{n}{number of simulated observations.}
}
\value{
\item{x}{Simulated Data}

\item{reg}{Markov chain regimes}
}
\description{
This function simulates observations from a univariate Gaussian HMM
}
\examples{
Q <- matrix(c(0.8, 0.3, 0.2, 0.7),2,2) ; mu <- c(-0.3 ,0.7) ; sigma <- c(0.15,0.05);
sim <- Sim.HMM.Gaussian.1d(mu,sigma,Q,eta0=1,n=100)

}
\author{
Bouchra R Nasri  and Bruno N Rémillard, January 31, 2019
}
