% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mortality_functions.R
\name{estM}
\alias{estM}
\title{Estimate mortality}
\usage{
estM(data_CO, data_SS, data_DWP = NULL, frac = 1,
  COdate = "DateFound", model_SE, model_CP, model_DWP = NULL,
  unitCol = NULL, SSdate = NULL, sizeCol = NULL, IDcol = NULL,
  DWPCol = NULL, nsim = 1000, max_intervals = 8)
}
\arguments{
\item{data_CO}{Carcass Observation data}

\item{data_SS}{Search Schedule data}

\item{data_DWP}{Survey unit (rows) by carcass class (columns) density weighted
proportion table}

\item{frac}{fraction carcasses on ground that was surveyed but not accounted
for in DWP}

\item{COdate}{Column name for the date found data}

\item{model_SE}{Searcher Efficiency model (or list of models if there are
multiple carcass classes)}

\item{model_CP}{Carcass Persistence model (or list of models if there are
multiple carcass classes)}

\item{model_DWP}{fitted dwp model (optional)}

\item{unitCol}{Column name for the unit indicator (optional)}

\item{SSdate}{Column name for the date searched data}

\item{sizeCol}{Name of colum in \code{data_CO} where the carcass classes
are recorded. Optional. If none provided, it is assumed there is no
distinctions among carcass classes.}

\item{IDcol}{column with unique carcass (CO) identifier}

\item{DWPCol}{Column name for the DWP values in the DWP table when no
carcass class is used and there is more than one column in \code{data_DWP}
that could be interpreted as DWP.}

\item{nsim}{the number of simulation draws}

\item{max_intervals}{maximum number of arrival intervals to consider
for each carcass}
}
\value{
list of Mhat, Aj, ghat, DWP (by carcass), and Xtot = total number of
 carcasses observe
}
\description{
Given given fitted Searcher Efficiency and Carcass 
  Persistence models; Search Schedule, Density Weighted Proportion,
  and Carcass Observation data; and information about the fraction of the
  the facility that was surveyed.
}
\examples{
 \dontrun{
 data(mock)
 model_SE <- pkm(formula_p = p ~ HabitatType, formula_k = k ~ 1,
              data = mock$SE
             )
 model_CP <- cpm(formula_l = l ~ Visibility, formula_s = s ~ Visibility, 
               data = mock$CP, dist = "weibull",
               left = "LastPresentDecimalDays", 
               right = "FirstAbsentDecimalDays"
             )
 eM <- estM(nsim = 1000, data_CO = mock$CO, data_SS = mock$SS, 
         data_DWP = mock$DWP, frac = 1, model_SE = model_SE, 
         model_CP = model_CP, COdate = "DateFound",
         DWPCol = "S", sizeCol = NULL
       )
 }

}
