% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{multiNMF}
\alias{multiNMF}
\title{Run NMF on a list of Seurat objects}
\usage{
multiNMF(
  obj.list,
  assay = "RNA",
  slot = "data",
  k = 5:6,
  hvg = NULL,
  nfeatures = 2000,
  L1 = c(0, 0),
  min.exp = 0.01,
  max.exp = 3,
  do_centering = TRUE,
  min.cells.per.sample = 10,
  hvg.blocklist = NULL,
  seed = 123
)
}
\arguments{
\item{obj.list}{A list of Seurat objects}

\item{assay}{Get data matrix from this assay}

\item{slot}{Get data matrix from this slot (=layer)}

\item{k}{Number of target components for NMF (can be a vector)}

\item{hvg}{List of pre-calculated variable genes to subset the matrix.
If hvg=NULL it calculates them automatically}

\item{nfeatures}{Number of HVG, if calculate_hvg=TRUE}

\item{L1}{L1 regularization term for NMF}

\item{min.exp}{Minimum average log-expression value for retaining genes}

\item{max.exp}{Maximum average log-expression value for retaining genes}

\item{do_centering}{Whether to center the data matrix}

\item{min.cells.per.sample}{Minimum numer of cells per sample (smaller 
samples will be ignored)}

\item{hvg.blocklist}{Optionally takes a vector or list of vectors of gene
names. These genes will be ignored for HVG detection. This is useful
to mitigateeffect of genes associated with technical artifacts and
batch effects (e.g. mitochondrial), and to exclude TCR and BCR 
adaptive immune(clone-specific) receptors. If set to `NULL` no genes 
will be excluded}

\item{seed}{Random seed}
}
\value{
Returns a list of NMF programs, one for each sample and for each
    value of 'k'. The format of each program in the list follosw the
    structure of \code{\link[RcppML]{nmf}} factorization models.
}
\description{
Given a list of Seurat objects, run non-negative matrix factorization on 
each sample individually, over a range of target NMF components (k).
}
\examples{
library(Seurat)
data(sampleObj)
geneNMF_programs <- multiNMF(list(sampleObj), k=5)

}
