% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fusion.R
\docType{class}
\name{Fusion}
\alias{Fusion}
\title{Class "Fusion"}
\description{
The main class to perform data fusion\cr
More information is available in the vignette "Data Fusion with GeoFIS"
}
\examples{
# more information about this example in the vignette "Data Fusion with GeoFIS"
# section "Learning illustration"

library(GeoFIS)

data(fusion_cars)

fusion <- NewFusion(fusion_cars)
a <- NewFusionInput("a", NewMfTrapezoidalInf(4, 20), "A")
v <- NewFusionInput("v", NewMfTrapezoidalSup(100, 500), "V")
s <- NewFusionInput("s", NewMfTrapezoidalSup(120, 220), "S")
c <- NewFusionInput("c", NewMfTrapezoidalInf(6, 16), "C")
owa_aggreg <- NewFusionAggreg("score", NewAggregOwa(c(1, 0, 0, 0)), a, v, s, c)
fusion$aggregate <- owa_aggreg
fusion$perform()
score <- fusion$output()["score"]
print(score)
}
\references{
{
\insertRef{gistam20}{GeoFIS}

\insertRef{denys20-ascii}{GeoFIS}
}
}
\seealso{
{
\link{NewFusion}

\href{https://www.geofis.org/en/documentation-en/data-fusion/}{Data Fusion documentation}
}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{aggregate}}{\link{Node} object, or a \link{list} of \link{Node}, The node(s) to aggregate}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Fusion-new}{\code{Fusion$new()}}
\item \href{#method-Fusion-perform}{\code{Fusion$perform()}}
\item \href{#method-Fusion-output}{\code{Fusion$output()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fusion-new"></a>}}
\if{latex}{\out{\hypertarget{method-Fusion-new}{}}}
\subsection{Method \code{new()}}{
The constructor to build an object of class \link{Fusion}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fusion$new(source)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{source}}{\link{data.frame} or \link{Spatial}*DataFrame object of \link{sp} package\cr
Keep only numeric attributes}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fusion-perform"></a>}}
\if{latex}{\out{\hypertarget{method-Fusion-perform}{}}}
\subsection{Method \code{perform()}}{
Perform the data fusion
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fusion$perform()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fusion-output"></a>}}
\if{latex}{\out{\hypertarget{method-Fusion-output}{}}}
\subsection{Method \code{output()}}{
Get the output aggregated data (same object type as data source)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fusion$output()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\link{data.frame} or \link{Spatial}*DataFrame object
}
}
}
