% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GeoLight.R
\name{mergeSites}
\alias{mergeSites}
\title{Function to merge sites}
\usage{
mergeSites(tFirst, tSecond, type, twl, site, degElevation,
  distThreshold = 250, alpha = c(0, 15), plot = TRUE)
}
\arguments{
\item{tFirst}{vector of sunrise/sunset times (e.g. 2008-12-01 08:30).}

\item{tSecond}{vector of of sunrise/sunset times (e.g. 2008-12-01 17:30).}

\item{type}{vector of either 1 or 2, defining \code{tFirst} as sunrise or sunset respectively.}

\item{twl}{data.frame containing twilights and at least \code{tFirst}, \code{tSecond} and \code{type}}

\item{site}{a \code{numerical vector} assigning each row to a particular
period. Stationary periods in numerical order and values >0,
migration/movement periods 0. This \code{vector} will be used as the initial state.}

\item{degElevation}{the sun elevation angle (in degrees) that defines twilight (e.g. -6 for "civil
twilight"). Either a single value, a \code{vector} with the same length as
\code{tFirst} or \code{nrow(x)}.}

\item{distThreshold}{a \code{numerical} value defining the threshold of the distance under
which consequtive sites should be merged (in km).}

\item{alpha}{mean and standard variation for position optimization process.}

\item{plot}{\code{logical}, if TRUE a plot comparing the inital and the final site selection.}
}
\value{
A \code{vector} with the merged site numbers
}
\description{
The \code{\link{changeLight}} functions provides a vector grouping the twilight times
into stationary (>0) and movement (0) periods. This function was written to enable the user
to merge sites based on the distance between consequtive sites. NOTE: The function requires
position estimate and desicison on whether sites should be merged will be made based on
the defined \code{distance}, the \code{cutoff} values and the provided positions. The analysis
is this dependent on the accuracy of the position estiamtes and should be applied to positons that
were estimated using a sensible sun elevation angle.
}
\author{
Simeon Lisovski
}

