% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ghfd_get_ftp_contents.R
\name{ghfd_get_ftp_contents}
\alias{ghfd_get_ftp_contents}
\title{Gets the contents of Bovespa ftp}
\usage{
ghfd_get_ftp_contents(type.market = "equity", max.dl.tries = 10)
}
\arguments{
\item{type.market}{The type of market to download data from ('equity', 'equity-odds','options', 'BMF' ).}

\item{max.dl.tries}{Maximum attempts to download the files from ftp}
}
\value{
A list with all files from the ftp that are related to executed trades
}
\description{
This function will access the Bovespa ftp and return a vector with all files related to trades (all others are ignored)
}
\examples{

\dontrun{
ftp.files <- ghfd_get_ftp_contents(type.market = 'equity')
print(ftp.files)
}
}

