% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gitrd_export_ITR_Data.R
\name{gitrd.export.ITR.data}
\alias{gitrd.export.ITR.data}
\title{Export tibble to an excel file}
\usage{
gitrd.export.ITR.data(data.in, base.file.name = paste0("GetITRData_Export_",
  Sys.Date()), type.export = "xlsx", format.data = "wide")
}
\arguments{
\item{data.in}{Tibble with financial information (output of gitrd.GetITRData)}

\item{base.file.name}{The basename of excel file (don't include extension)}

\item{type.export}{The extension of the desired format (only 'xlsx' implemented so far)}

\item{format.data}{The format of output. 'wide' (default) for a wide table and 'long' for a long table}
}
\value{
nothing
}
\description{
Export tibble to an excel file
}
\examples{

# get example data from RData file
my.f <- system.file('extdata/ExampleReport_Petrobras.RData', package = 'GetITRData')
load(my.f)

\dontrun{ # dontrun: keep cran check time short
gitrd.export.ITR.data(df.reports, base.file.name = 'MyExcelFile', format.data = 'wide')
}
}
