% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtdd_download_TD_data.R
\name{download.TD.data}
\alias{download.TD.data}
\title{Downloads data of Brazilian government bonds directly from the website}
\usage{
download.TD.data(asset.codes = "LTN", dl.folder = "TD Files",
  do.clean.up = F, do.overwrite = F, n.dl = NULL)
}
\arguments{
\item{asset.codes}{Strings that identify the assets (1 or more assets) in the
names of the excel files. E.g. asset.codes = 'LTN'. When set to NULL, it
will download all available assets}

\item{dl.folder}{Name of folder to save excel files from tesouro direto (will
create if it does not exists)}

\item{do.clean.up}{Clean up folder before downloading? (TRUE or FALSE)}

\item{do.overwrite}{Overwrite excel files? (TRUE or FALSE). If FALSE, will
only download the new data for the current year}

\item{n.dl}{Sets how many files to download from the website. Used only to
decrease CRAN CHECK time. The default value is NULL (downloads all files)}
}
\value{
TRUE if successful
}
\description{
This function looks into the tesouro direto website
(http://www.tesouro.fazenda.gov.br/tesouro-direto-balanco-e-estatisticas) and
downloads all of the files containing prices and yields of government bonds.
You can use input asset.codes to restrict the downloads to specific bonds
}
\examples{
# only download file where string LTN is found
# (only 1 file for simplicity)
\dontrun{
download.TD.data(asset.codes = 'LTN', n.dl = 1)
}
# The excel file should be available in folder 'TD Files' (default name)

}
