% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gitstats_functions.R
\name{get_storage}
\alias{get_storage}
\title{Get data from \code{GitStats} storage}
\usage{
get_storage(gitstats_object, storage = NULL)
}
\arguments{
\item{gitstats_object}{A GitStats object.}

\item{storage}{A character, type of the data you want to get from storage:
\code{commits}, \code{repositories}, \code{release_logs}, \code{users}, \code{files},
\code{files_structure}, \code{R_package_usage} or \code{release_logs}.}
}
\value{
A list of tibbles (if \code{storage} set to \code{NULL}) or a tibble (if
\code{storage} defined).
}
\description{
Retrieves whole or particular data (see \code{storage} parameter)
pulled earlier with \code{GitStats}.
}
\examples{
\dontrun{
 my_gitstats <- create_gitstats() \%>\%
  set_github_host(
    token = Sys.getenv("GITHUB_PAT"),
    orgs = c("r-world-devs", "openpharma")
  )
  get_release_logs(my_gistats, since = "2024-01-01")
  get_repos(my_gitstats)

  release_logs <- get_storage(
    gitstats_object = my_gitstats,
    storage = "release_logs"
  )
}
}
