% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{exponential_nonstat_var}
\alias{exponential_nonstat_var}
\alias{d_exponential_nonstat_var}
\title{Isotropic exponential covariance function, nonstationary variances}
\usage{
exponential_nonstat_var(covparms, Z)

d_exponential_nonstat_var(covparms, Z)
}
\arguments{
\item{covparms}{A vector with covariance parameters
in the form (variance, range, nugget, <nonstat variance parameters>).
The number of nonstationary variance parameters should equal \code{p}.}

\item{Z}{A matrix with \code{n} rows and \code{2} columns for spatial
locations + \code{p} columns describing spatial basis functions.
Each row of locs gives a point in R^2 (two dimensions only!) + the value
of \code{p} spatial basis functions.}
}
\value{
A matrix with \code{n} rows and \code{n} columns, with the i,j entry
containing the covariance between observations at \code{locs[i,]} and
\code{locs[j,]}.
}
\description{
From a matrix of locations and covariance parameters of the form
(variance, range, nugget, <nonstat variance parameters>), 
return the square matrix of all pairwise covariances.
}
\section{Functions}{
\itemize{
\item \code{d_exponential_nonstat_var}: Derivatives with respect to parameters
}}

\section{Parameterization}{

This covariance function multiplies the isotropic exponential covariance
by a nonstationary variance function. The form of the covariance is
\deqn{ C(x,y) = exp( \phi(x) + \phi(y) ) M(x,y) }
where M(x,y) is the isotropic exponential covariance, and 
\deqn{ \phi(x) = c_1 \phi_1(x) + ... + c_p \phi_p(x) }
where \eqn{\phi_1,...,\phi_p} are the spatial basis functions
contained in the last \code{p} columns of \code{Z}, and 
\eqn{c_1,...,c_p} are the nonstationary variance parameters.
}

