% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CUSUM.R
\name{single_CUSUM}
\alias{single_CUSUM}
\title{CUSUM transformation of matrix at a specific position}
\usage{
single_CUSUM(X, start = NULL, stop = NULL, pos)
}
\arguments{
\item{X}{Matrix of observations, where each row contains a time series}

\item{start}{Starting point of interval over which the CUSUM should be computed, subtracted by one}

\item{stop}{Ending point of interval over which the CUSUM should be computed, subtracted by one}

\item{pos}{Position at which the CUSUM should be evaluated, subtracted by one}
}
\value{
A vector of CUSUM values, each corresponding to a row of the input matrix. The \eqn{i}-th element corresponds to the CUSUM transformation of the \eqn{i}-th row of \eqn{X}, computed over the interval \eqn{(\code{start}+1,\code{end}+1]} and evaluated at position \eqn{\code{pos}}, i.e. 
\eqn{\sqrt{\frac{e-v}{(e-s)(v-s)}}\sum_{t=s+1}^v X_{i,t} - \sqrt{\frac{v-s}{(e-s)(e-v)}}\sum_{t=v+1}^e X_{i,t}}, 
where \eqn{s = (\code{start}+1)}, \eqn{e = (\code{stop}+1)} and \eqn{v = \code{pos}+1}.
}
\description{
R wrapper for C function computing the CUSUM transformation of matrix over an interval \eqn{(s,e]} evaluated at a specific position. For compatibility with C indexing, the user should subtract \eqn{1} from \eqn{s}, \eqn{e} and \eqn{v} when supplying the arguments to the function. If start and stop are not supplied, the CUSUM is computed over the full data, so \eqn{(s,e] = (0,n]}.
}
\examples{
n = 10
p = 10
set.seed(101)
X = matrix(rnorm(n*p), ncol = n, nrow=p)
# CUSUM over the full data (s,e] = (0,n] evaluated at position v=4
position = 4
X_cusum_single = single_CUSUM(X,pos = position-1)
X_cusum_single

# verifying that this corresponds to the 4-th row of output of CUSUM():
X_cusum = CUSUM(X)
X_cusum[,4]
}
