% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mobility.R
\docType{data}
\name{mobility}
\alias{mobility}
\title{Data for Mobility Changes in Response to COVID-19}
\format{
A data frame with 9,333 rows and 5 variables:
\describe{
  \item{state}{State (originally admin1)}
  \item{date}{Date in YYYY-MM-DD format}
  \item{samples}{The number of samples observed in the state on that date
  (summed across counties)}
  \item{m50}{The median of the max-distance mobility (representing the
  distance a typical member of a given population moves in a day) for all
  samples in a county, averaged across counties.}
  \item{m50_index}{The percent of normal m50 in the region, with normal m50
  defined during 2020-02-17 to 2020-03-07, averaged across counties.}
}

Note from the data website: "Data for 2020-04-20, 2020-05-29, 2020-10-08,
2020-12-11 through 2020-12-18, 2021-01-08 through 2021-01-14, 2021-04-07,
2021-04-12 and 2021-04-21 to present did not meet quality control standards,
and was not released."
}
\source{
Data was obtained from Descartes Labs
\url{https://descarteslabs.com/resources/}

Warren, Michael S. & Skillman, Samuel W. "Mobility Changes in Response to
COVID-19". arXiv:2003.14228 [cs.SI], Mar. 2020. arxiv.org/abs/2003.14228

\url{https://github.com/descarteslabs/DL-COVID-19}
}
\usage{
mobility
}
\description{
2020 mobility statistics at the state level from Descartes Labs.
}
\keyword{datasets}
