% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_map.R
\name{plot_map}
\alias{plot_map}
\title{Map of circular clusters}
\usage{
plot_map(spobject, centres, radius, system, colors = "red")
}
\arguments{
\item{spobject}{SpObject. SpatialObject with the same coordinates system that centres (the same that sites_coord in the scan functions)}

\item{centres}{numeric matrix or vector if only one cluster was detected. Coordinates of the centres of each cluster.}

\item{radius}{numeric vector. Radius of each cluster in the user units if system = "Euclidean", or in km if system = "WGS84" (in the output of the scan functions)}

\item{system}{character. System in which the coordinates are expressed: "Euclidean" or "WGS84".}

\item{colors}{character. Colors of the clusters. If length(colors)=1 all the clusters will be in this color. Else it should be a vector of length the number of clusters to plot.}
}
\value{
No value returned, plots a map of the sites and the circular clusters.
}
\description{
This function plots a map of the sites and the circular clusters.
}
