% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HDSpatialScan_plotSummary.R
\name{plotSummary}
\alias{plotSummary}
\title{Generic function to plot a summary}
\usage{
plotSummary(x, ...)
}
\arguments{
\item{x}{An object for which the summary is to be plotted.}

\item{...}{Additional arguments affecting the summary produced.}
}
\value{
No value returned, plots the summary.
}
\description{
This function is a generic function to plot a summary.
}
\examples{
\donttest{
library(sp)
data("map_sites")
data("multi_data")
coords <- coordinates(map_sites)

res_mnp <- SpatialScan(method = "MNP", data = multi_data, sites_coord = coords,
system = "WGS84", mini = 1, maxi = nrow(coords)/2,
variable_names = c("NO2", "O3", "PM10", "PM2.5"))$MNP

plotSummary(x = res_mnp, type = "mean")}
\dontshow{
library(sp)
data("map_sites")
data("multi_data")
indices <- c(51:75)
coords <- coordinates(map_sites[indices,])
res_mnp <- SpatialScan(method = "MNP", data = multi_data[indices,],
sites_coord = coords, system = "WGS84", mini = 1, maxi = nrow(coords)/2,
MC = 99)$MNP
if(length(res_mnp$sites_clusters)>0){
plotSummary(x = res_mnp, type = "mean")
}
}

}
\seealso{
\code{\link{plotSummary.ResScanOutputMulti}}, \code{\link{plotSummary.ResScanOutputUniFunct}} and \code{\link{plotSummary.ResScanOutputMultiFunct}}
}
