% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.utility.R
\name{graph.levels}
\alias{graph.levels}
\title{Build Graph Levels}
\usage{
graph.levels(g, root = "00")
}
\arguments{
\item{g}{an object of class \code{graphNEL}}

\item{root}{name of the root node (\code{def. root="00"})}
}
\value{
a list of the nodes grouped w.r.t. the distance from the root: the first element of the list corresponds to the root node (level 0),
the second to nodes at maximum distance 1 (level 1), the third to the node at maximum distance 3 (level 2) and so on.
}
\description{
This function groups a set of nodes in according to their maximum depth in the graph. It first inverts the weights 
of the graph and then applies the Bellman Ford algorithm to find the shortest path, achieving in this way the longest path.
}
\examples{
data(graph);
root <- root.node(g);
lev <- graph.levels(g, root=root);
}
