% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heuristic.methods.R
\name{Heuristic-Methods}
\alias{Heuristic-Methods}
\alias{heuristic.max}
\alias{heuristic.and}
\alias{heuristic.or}
\title{Obozinski Heuristic Methods}
\usage{
heuristic.max(S, g, root = "00")

heuristic.and(S, g, root = "00")

heuristic.or(S, g, root = "00")
}
\arguments{
\item{S}{a named flat scores matrix with examples on rows and classes on columns.}

\item{g}{a graph of class \code{graphNEL}. It represents the hierarchy of the classes.}

\item{root}{name of the class that it is the top-level (root) of the hierarchy (\code{def:00}).}
}
\value{
a matrix with the scores of the classes corrected according to the chosen heuristic algorithm.
}
\description{
Implementation of the Heuristic Methods MAX, AND, OR (\cite{Obozinski et al., Genome Biology, 2008, 
\href{https://genomebiology.biomedcentral.com/articles/10.1186/gb-2008-9-s1-s6}{doi:10.1186/gb-2008-9-s1-s6}}).
}
\details{
Heuristic Methods:
\enumerate{
 \item \bold{MAX}: reports the largest logist regression (LR) value of self and all descendants: \eqn{p_i = max_{j \in descendants(i)} \hat{p_j}};
 \item \bold{AND}: reports the product of LR values of all ancestors and self. This is equivalent to computing the probability that all 
ancestral terms are "on" assuming that, conditional on the data, all predictions are independent: \eqn{p_i = \prod_{j \in ancestors(i)} \hat{p_j}};
 \item \bold{OR}: computes the probability that at least one of the descendant terms is "on" assuming again that, conditional on the data, 
all predictions are independent: \eqn{1 - p_i = \prod_{j \in descendants(i)} (1 - \hat{p_j})};
}
}
\examples{
data(graph);
data(scores);
data(labels);
root  <- root.node(g);
S.max <- heuristic.max(S,g,root);
S.and <- heuristic.and(S,g,root);
S.or  <- heuristic.or(S,g,root);
}
