% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpav.R
\name{gpav.holdout}
\alias{gpav.holdout}
\title{GPAV holdout}
\usage{
gpav.holdout(
  S,
  g,
  testIndex,
  W = NULL,
  parallel = FALSE,
  ncores = 1,
  norm = TRUE,
  norm.type = NULL
)
}
\arguments{
\item{S}{a named flat scores matrix with examples on rows and classes on columns (root node included).}

\item{g}{a graph of class \code{graphNEL}. It represents the hierarchy of the classes.}

\item{testIndex}{a vector of integer numbers corresponding to the indexes of the elements (rows) of the scores matrix \code{S} to be used in the test set.}

\item{W}{vector of weight relative to a single example. If \code{W=NULL} (def.) it is assumed that
\code{W} is a unitary vector of the same length of the columns' number of the matrix \code{S} (root node included).}

\item{parallel}{a boolean value. Should the parallel version \code{GPAV} be run?
\itemize{
   \item \code{TRUE}: execute the parallel implementation of \code{GPAV} (\code{\link{gpav.parallel}});
   \item \code{FALSE} (\code{def.}): execute the sequential implementation of \code{GPAV} (\code{\link{gpav.over.examples}});
}}

\item{ncores}{number of cores to use for parallel execution. Set \code{ncores=1} if \code{parallel=FALSE},
otherwise set \code{ncores} to the desired number of cores.}

\item{norm}{a boolean value. Should the flat score matrix be normalized? By default \code{norm=FALSE}.
If \code{norm=TRUE} the matrix \code{S} is normalized according to the normalization type selected in \code{norm.type}.}

\item{norm.type}{a string character. It can be one of the following values:
\enumerate{
\item \code{NULL} (def.): none normalization is applied (\code{norm=FALSE})
\item \code{maxnorm}: each score is divided for the maximum value of each class;
\item \code{qnorm}: quantile normalization. \pkg{preprocessCore} package is used;
}}
}
\value{
A named matrix with the scores of the classes corrected according to the \code{GPAV} algorithm. Rows of the matrix are shrunk to \code{testIndex}.
}
\description{
Correct the computed scores in a hierarchy according to the \code{GPAV} algorithm by applying a classical holdout procedure.
}
\examples{
data(graph);
data(scores);
data(test.index);
S.gpav <- gpav.holdout(S, g, testIndex=test.index, norm=FALSE, norm.type=NULL);
}
