% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BDtoPyPop.R
\name{pypopHeaders}
\alias{pypopHeaders}
\title{Convert BIGDAWG File Headers to PyPop Format}
\usage{
pypopHeaders(colHead)
}
\arguments{
\item{colHead}{A vector of column names. BIGDAWG format requires that the first two header values are the sample identifier character string and the subject status (0 or 1). All other header values should be paired locus/gene names.}
}
\value{
A PyPop-formatted column header vector.
}
\description{
Convert the header of a BIGDAWG-formatted data frame into a Python for Population Genomics (PyPop) formatted header.
}
\note{
This function returns unique locus names for each column. For example, "A_1" and "A_2" headers will be returned for two "A" locus columns. PyPop configuration (.ini) files allow this format to be customized.
}
\examples{
pyHead <- pypopHeaders(colnames(sHLAdata))

}
\references{
Lancaster et al. Front Immunol. 2024 Apr 2;15:1378512. https://pubmed.ncbi.nlm.nih.gov/38629078/

Pappas et al. Hum Immunol. 2016 Mar 77(3):283-287. https://pubmed.ncbi.nlm.nih.gov/26708359/
}
\seealso{
\href{http://pypop.org/docs/guide-chapter-usage.html#a-minimal-configuration-file}{PyPop Configuration File}
}
