% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun_estimate_mean_treat.R
\name{fit.ate.adj2.adj2c.Random}
\alias{fit.ate.adj2.adj2c.Random}
\title{Covariate-Adjusted Treatment Effect Estimation under the Randomization-based Framework}
\usage{
fit.ate.adj2.adj2c.Random(Y, X, A, pi1_hat = NULL)
}
\arguments{
\item{Y}{Numeric vector of length n containing observed responses.}

\item{X}{Numeric matrix (n x p) of covariates. Centering is required. Intercept term can include or not.}

\item{A}{Binary vector of length n indicating treatment assignment (1 = treatment, 0 = control).}

\item{pi1_hat}{Default is NULL. The assignment probability for the simple randomization.}
}
\value{
A list containing three named vectors, including point estimates and variance estimates:
\describe{
  \item{tau_vec}{Point estimates:
    \itemize{
      \item{\code{adj2}:} Point estimation of the HOIF-inspired debiased estimator given by Zhao et al.(2024).
      \item{\code{adj2c}:} Point estimation of the debiased estimator given by Lu et al. (2023), which is also the HOIF-inspired debiased estimator given by Zhao et al.(2024).
    }}
  \item{var_vec_v1}{Variance estimates for adj2 and adj2c, with formulas inspired by Lu et al. (2023).:
    \itemize{
      \item{\code{adj2}:} Variance for \code{adj2}.
      \item{\code{adj2c}:} Variance for \code{adj2c}.
    }}
  \item{var_vec_v2}{Variance estimates for adj2 and adj2c, with formulas given in Zhao et al. (2024), which is more conservative.
    \itemize{
      \item{\code{adj2}:} Variance  for \code{adj2}.
      \item{\code{adj2c}:} Variance  for \code{adj2c}.
    }}
}
}
\description{
Implements the (HOIF-inspired) debiased estimators for average treatment effect (ATE)  with variance estimation
using asymptotic-variance. Designed for randomized experiments with moderately high-dimensional covariates.
}
\examples{
set.seed(100)
n <- 500
p <- n * 0.3
beta <- runif(p, -1 / sqrt(p), 1 / sqrt(p))

X <- mvtnorm::rmvt(n, sigma = diag(1, p), df = 3)
Y1 <- as.numeric(X \%*\% beta)
Y0 <- as.numeric(X \%*\% beta - 1)

pi1 <- 2/3
n1 <- ceiling(n * pi1)
ind <- sample(n, size = n1)
A <- rep(0, n)
A[ind] <- 1
Y <- Y1 * A + Y0 * (1 - A)

Xc <- cbind(1, scale(X, scale = FALSE))
result.adj2.adj2c.random.ls <- fit.ate.adj2.adj2c.Random(Y, Xc, A)
point_est <- result.adj2.adj2c.random.ls$tau_vec
var_est_v1 <- result.adj2.adj2c.random.ls$var_vec_v1
var_est_v2 <- result.adj2.adj2c.random.ls$var_vec_v2
point_est
var_est_v1
var_est_v2

}
\references{
Lu, X., Yang, F. and Wang, Y. (2023) \emph{Debiased regression adjustment in completely randomized experiments with moderately high-dimensional covariates. arXiv preprint, arXiv:2309.02073}, \doi{10.48550/arXiv.2309.02073}. \cr
Zhao, S., Wang, X., Liu, L. and Zhang, X. (2024) \emph{Covariate Adjustment in Randomized Experiments Motivated by Higher-Order Influence Functions. arXiv preprint, arXiv:2411.08491}, \doi{10.48550/arXiv.2411.08491}.
}
\keyword{internal}
