% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_GroupSLCClasses.R
\name{GroupSLCClasses}
\alias{GroupSLCClasses}
\title{Calculate grouped sums for SLC classes in a GeoData file}
\usage{
GroupSLCClasses(
  gd,
  gcl = NULL,
  type = c("landuse", "soil", "crop"),
  group = NULL,
  abs.area = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{gd}{Data frame containing columns with SUBIDs, SLC fractions, and SUBID areas if \code{abs.area = TRUE}. Typically a 'GeoData.txt' file
imported with \code{\link{ReadGeoData}}.}

\item{gcl}{Data frame containing columns with SLCs and corresponding landuse and soil class IDs, typically a 'GeoClass.txt'
file imported with \code{\link{ReadGeoClass}}. Must be provided if no \code{group} argument is given.}

\item{type}{Character string keyword for use with \code{gcl}. Type of grouping index, either \code{"landuse"}, \code{"soil"}, or \code{"crop"},
can be abbreviated.}

\item{group}{Integer vector, of same length as number of SLC classes in \code{gd}. Alternative grouping index specification to \code{gcl} + \code{type}.}

\item{abs.area}{Logical, if \code{TRUE}, then absolute areas will be calculated for each group, rather than area fractions.}

\item{verbose}{Logical, if \code{TRUE} then information and progress bar will be printed.}
}
\value{
\code{GroupSLClasses} returns the data frame with SUBIDs, SUBID areas, and grouped SLC class columns.
}
\description{
\code{GroupSLCClasses} calculates grouped sums for SLC classes (area fractions or absolute areas) based on land use, soil, or crop groups in a GeoClass
table, or any other user-provided grouping index.
}
\details{
If absolute areas are calculated, area units will correspond to areas provided in \code{gd}.
}
\examples{
# Import source data
te1 <- ReadGeoData(filename = system.file("demo_model", "GeoData.txt", package = "HYPEtools"))
te2 <- ReadGeoClass(filename = system.file("demo_model", "GeoClass.txt", package = "HYPEtools"))
# Calculate soil groups
GroupSLCClasses(gd = te1, gcl = te2, type = "s")

}
