% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_VariableLookup.R
\name{VariableLookup}
\alias{VariableLookup}
\alias{VariableInfo}
\alias{VariableSearch}
\title{Lookup Functions For HYPE Variables}
\usage{
VariableInfo(variable, info = "Name")

VariableSearch(
  search,
  info = c("ID", "Name", "Unit", "Description", "Aggregation", "Component"),
  ignore_case = TRUE
)
}
\arguments{
\item{variable}{String, HYPE Variable ID (e.g. "COUT").}

\item{info}{A vector of strings describing HYPE variable attribute information to return/search: "ID", "Name", "Unit", "Description", "Aggregation", and/or "Component".}

\item{search}{String, search HYPE variable info for string matches in \code{info} attributes.}

\item{ignore_case}{Logical, should case differences be ignored in the match?}
}
\value{
\code{VariableInfo} Returns a named list of the selected \code{info} for the specified \code{variable} ID.
\code{VariableInfo} returns a tibble of the search results.
}
\description{
Lookup information (e.g. Name, Units) for a specific HYPE variable ID, or find HYPE variable information for a search term.
}
\details{
The \code{VariableInfo} and \code{VariableSearch} functions provide features to lookup information on HYPE variables from the
\href{http://www.smhi.net/hype/wiki/doku.php?id=start:hype_file_reference:info.txt:variables}{HYPE Wiki}.
\code{VariableInfo} can be used to return information (e.g. Name, Units) for a known HYPE Variable ID.
\code{VariableSearch} can be used to search for e.g. an unknown HYPE variable ID based on a \code{search} term.
The \code{info} argument can be used to select which information to return or search.
}
\examples{
VariableInfo(variable = "COUT", info = c("Name","Unit"))
VariableSearch(search = "ccSS", info = c("ID", "Name", "Description"))

}
