% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/harmonic.regression.R
\name{harmonic.regression}
\alias{harmonic.regression}
\title{Harmonic Regression}
\usage{
harmonic.regression(inputts, inputtime, Tau = 24, normalize = TRUE,
  norm.pol = FALSE, norm.pol.degree = 1, trend.eliminate = FALSE,
  trend.degree = 1)
}
\arguments{
\item{inputts}{Matrix of time series.  Rows correspond to time points,
columns to samples.  If a vector is provided, it is coerced to a matrix.}

\item{inputtime}{Vector of the time points corresponding to the row in the
time series matrix.}

\item{Tau}{Scalar giving the oscillation period to estimate and test for.}

\item{normalize}{Boolean, set to \code{TRUE} if normalization is to be
performed (default).  Unless \code{norm.pol=TRUE}, normalization is
performed by dividing with the mean.}

\item{norm.pol}{Boolean, set to \code{TRUE} if a polynomial should be fitted
to each time series, and used for normalization.  In this case, each point
in a time series will be divided by the value of the fitted polynomial.
Defaults to \code{FALSE}.}

\item{norm.pol.degree}{Scalar indicating the polynomial degree for the
normalization (ignored if \code{norm.pol=FALSE}).}

\item{trend.eliminate}{Boolean, set to \code{TRUE} if trend elimination is to
be performed (see Details above).  Defaults to \code{FALSE}.}

\item{trend.degree}{Integer indicading the polynomial degree for the trend
elimination, default is 1.  Ignored when \code{trend.eliminate=FALSE},
which is the default.}
}
\value{
A list containing: \tabular{ll}{
 \code{means} \tab Vector (if \code{norm.pol=FALSE}) or matrix (otherwise) of
 the means or coefficients of the fitted polynomial used for the
 normalization \cr
 \code{normts} \tab Matrix of mean-scaled or normalized-by-polynomial time
 series, same dimensionality as \code{inputts} \cr
 \code{fit.vals} \tab Matrix of model fitted values to \code{inputts} \cr
 \code{norm.fit.vals} \tab Matrix of model fitted values to the normalized
 (trend eliminated or mean scaled) time series \cr
 \code{pars} \tab Data frame of estimated amplitudes and phases (in radians,
 between 0 and \eqn{2\pi}) \cr
 \code{pvals} \tab Vector of p-values according to an F-test of the model fit
 against a restricted model (mean-centering only) \cr
 \code{qvals} \tab Vector of Benjamini-Hochberg adjusted p-values \cr
 \code{ci} \tab Data frame of one-sided approximative 95\% (\eqn{2\sigma})
 confidence intervals for the estimated amplitudes and phases \cr
 \code{coeffs} \tab Matrix of estimated model parameters \eqn{a} and \eqn{b}
 \cr
 \code{ssr} \tab Vector of sum square residuals for the model fits \cr
 \code{df} \tab Scalar if \code{inputts} does not contain \code{NA}s and
 Vector otherwise, representing the degrees of freedom of the residual from
 the fit \cr
 \code{ssx} \tab Matrix (3 times 3, if \code{inputts} does not contain
 \code{NA}s, a list of such matrices, one for each time series, otherwise) of
 covariances for the dependent variables corresponding to (\eqn{m}, \eqn{a
 cos(\omega t)}, and \eqn{b sin(\omega t)}, respecively) \cr
}
}
\description{
Estimates amplitudes and phases along with confidence intervals and p-values
from a set of time series that may oscillate with a specified period. A
model, per default \deqn{y = m + a cos(\omega t) + b sin(\omega t),} is
fitted to the time series.  This model is equivalent to the model \deqn{m + c
cos(\omega t - \phi),} with amplitude \eqn{c = \sqrt(a^2 + b^2)} and phase
\eqn{\phi = atan2(b, a)}. P-values for \eqn{c > 0} (more precisely: either
\eqn{a} or \eqn{b > 0} ) are computed by an F-test.  Confidence intervals for
the amplitudes and phases are computed by a linear error propagation
approximation.
}
\details{
The default setting is that the time series are normalized with their mean
values.  Optionally a polynomial of degree 1 or more is first fitted to each
time series, whereupon the original time series are normalized by dividing
with the fitted values at each point, thus trends in a fold-change sense are
assumed.  Another option is trend elimination, in which case the same model
plus a polynomial: \eqn{y = m + a cos(\omega t) + b sin(\omega t) + et + ft^2
+ ... } is fitted to the (possibly normalized) data.  In this case, returned
p-values still only concern the alternative \eqn{c > 0} as defined above.

Values returned include normalized time series (if normalization is
performed), normalization weights (means or polynomial coefficients if
polynomial normalilzation is used), fitted normalized curves, fitted
non-normalized curves, a data frame of amplitudes and phases (in radians),
p-values according to an F-test (Halberg 1967), Benjamini-Hochberg adjusted
p-values, a data frame of approximately 1.96 standard deviations for the
amplitude and phase estimates, a matrix of coefficients a and b and possibly
c,... , the sum square resuduals after the fit for each time series, and the
covariance matrix for the three independent variables (\eqn{1},
\eqn{cos(\omega t)}, and \eqn{sin(\omega t)}).  The latter can be used in
post-processing e.g. to obtain individual p-values for coefficients by
t-tests.
}
\references{
Halberg F, Tong YL, Johnson EA: Circadian System Phase -- An
  Aspect of Temporal Morphology; Procedures and Illustrative Examples. in:
  The Cellular Aspects of Biorhythms, Springer 1967.
}

