% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/minmax.periodic.R
\name{minmax.periodic}
\alias{minmax.periodic}
\title{Search for minimum and maximum temperatures in periodic timeseries}
\usage{
minmax.periodic(time.minmax.daily = NULL, time.minmax = NULL,
  progressbar = FALSE,
  observed = stop("data.frame with observed temperatures"), period = 24)
}
\arguments{
\item{time.minmax.daily}{A named vector with Min and Max being the time in the day with minimum and maximum temperatures}

\item{time.minmax}{A name vector daily time in the day with minimum and maximum temperatures}

\item{progressbar}{Does a progression bar must be shown}

\item{observed}{A dataframe with at least two columns: time and temperatures. A third column SD can indicate the know error in temperature}

\item{period}{The unit of day period (24 for hours, 24*60 for minutes)}
}
\value{
A data.frame with a column time, a column temperature and a column SD
}
\description{
Search for minimum and maximum for periodic timeseries when only intermediate values are known.\cr
For each couple of value with an increasing or decreasing segment of
the sinusoid function, it is possible to estimate a minimum and maximum
values using analytical algebra.\cr
Then the average and standard deviations of all minima and maxima are evaluated.\cr
It should be noted that any extremum can be estimated at least twice, one by
increasing segment and one by decreasing segment. Both are used here to produce SD.
}
\details{
minmax.periodic search for minimum and maximum temperatures in periodic timeseries
}
\examples{
\dontrun{
# Generate a timeserie of time
time.obs <- NULL
for (i in 0:9) time.obs <- c(time.obs, c(0, 6, 12, 18)+i*24)
# For these time, generate a timeseries of temperatures
temp.obs <- rep(NA, length(time.obs))
temp.obs[3+(0:9)*4] <- rnorm(10, 25, 3)
temp.obs[1+(0:9)*4] <- rnorm(10, 10, 3)
for (i in 1:(length(time.obs)-1))
  if (is.na(temp.obs[i]))
  temp.obs[i] <- mean(c(temp.obs[i-1], temp.obs[i+1]))
  if (is.na(temp.obs[length(time.obs)]))
  temp.obs[length(time.obs)] <- temp.obs[length(time.obs)-1]/2
observed <- data.frame(time=time.obs, temperature=temp.obs)
# Search for the minimum and maximum values
r <- minmax.periodic(time.minmax.daily=c(Min=2, Max=15),
observed=observed, period=24)

# Estimate all the temperatures for these values
t <- temperature.periodic(minmax=r)

plot_errbar(x=t[,"time"], y=t[,"temperature"],
errbar.y=ifelse(is.na(t[,"sd"]), 0, 2*t[,"sd"]),
type="l", las=1, bty="n", errbar.y.polygon = TRUE,
xlab="hours", ylab="Temperatures", ylim=c(0, 35),
errbar.y.polygon.list = list(col="grey"))

plot_add(x=t[,"time"], y=t[,"temperature"], type="l")
}
}
\author{
Marc Girondot
}
\seealso{
Other Daily patterns of temperature: \code{\link{temperature.periodic}}
}

