% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist.entropic.R
\name{dist.entropic}
\alias{dist.entropic}
\title{Return an index of quantitative asymmetry and complexity}
\usage{
dist.entropic(l1, l2, details = FALSE)
}
\arguments{
\item{l1}{Set of measures at one side of an organism}

\item{l2}{Set of measures at the other side of an organism}

\item{details}{If TRUE, will show the details of computing}
}
\value{
A numeric value
}
\description{
Return an index of quantitative asymmetry and complexity. The higher is the value, 
the higher is the complexity (number of objects) and diversity (difference between them).\cr
The indice is based on the product of the average angular distance of Edwards (1971) with the 
geometric mean of the Shannon entropy H for both sides.
}
\details{
dist.entropic returns an index of quantitative asymmetry and complexity
}
\examples{
l1 <- c(0.1, 0.1, 0.05, 0.2, 0.3, 0.25)
l2 <- c(0.2, 0.3, 0.5)
dist.entropic(l1, l2)

l1 <- c(0.1, 0.1, 0.05, 0.2, 0.3, 0.25)
l2 <- c(0.1, 0.1, 0.05, 0.2, 0.3, 0.25)
dist.entropic(l1, l2)

l1 <- c(0.2, 0.3, 0.5)
l2 <- c(0.2, 0.3, 0.5)
dist.entropic(l1, l2)

l1 <- c(0.2, 0.2, 0.2, 0.2, 0.2)
l2 <- c(0.2, 0.3, 0.5)
dist.entropic(l1, l2)

l1 <- c(0.2, 0.2, 0.2, 0.2, 0.2)
l2 <- c(0.3333, 0.3333, 0.3333)
dist.entropic(l1, l2)

l1 <- c(0.2, 0.2, 0.2, 0.2, 0.2)
l2 <- c(0.2, 0.2, 0.2, 0.2, 0.2)
dist.entropic(l1, l2)

l1 <- c(0.3333, 0.3333, 0.3333)
l2 <- c(0.3333, 0.3333, 0.3333)
dist.entropic(l1, l2)
}
\author{
Marc Girondot
}
\references{
Edwards, A.W.F., 1971. Distances between populations on the basis of gene frequencies. Biometrics 27, 873–881.\cr
Shannon C.E. 1948 A mathematical theory of communication. Bell System Technical Journal 27(3), 379-423.\cr
}

