% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HeriTools.R
\name{computeVPC.NB}
\alias{computeVPC.NB}
\title{Calculate the negative binomial (NB) variance partition coefficient (VPC)
for one or more features.}
\usage{
computeVPC.NB(para)
}
\arguments{
\item{para}{A \eqn{G \times 3}{G x 3} matrix of negative binomial fit 
parameters for \eqn{G} features, \eqn{G\geq 1}. The column order is intercept 
\eqn{\alpha_g}, random effect \eqn{\sigma_g^2 (\sigma_g^2\geq0)}, 
 and dispersion \eqn{\phi (\phi>0)}.}
}
\value{
A \eqn{G \times 1}{G x 1} matrix consisting of VPC for
\eqn{G} features based on negative binomial mixed model. Column name 
is "NB-fit"; row names are the feature names.
}
\description{
Calculate the NB VPC for one or more features following the model fitting 
function fit.NB().
}
\examples{
## Compute VPC for each feature under negative binomial mixed model.
vpc.nb <- computeVPC.NB(para_nb)

## Visulize the distribution of the VPCs. 
hist(vpc.nb, breaks = 50, col = "cyan")

## Plot sorted VPCs.
plot(sort(vpc.nb), ylab = "Heritability (h2)", ylim = c(0,1), 
main = "Sorted NB VPC scores")
abline(h = 0.9, lty = 2, col = "red")
text(50, 0.92, "h2 = 0.9", col = "red")
}
