% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mineHPD.R
\name{mineHPD}
\alias{mineHPD}
\title{Examine (mine) a Hive Plot Data Object and Extract Information Contained
Within It}
\usage{
mineHPD(HPD, option = "rad <- tot.edge.count")
}
\arguments{
\item{HPD}{A \code{\link{HivePlotData}} object.}

\item{option}{A character string giving the option desired.  See Details for
current options.}
}
\value{
A modified \code{HivePlotData} object.
}
\description{
A \code{HivePlotData object}, especially one created fresh using
\code{\link{dot2HPD}}, generally contains a lot of hidden information about
the network described. This function can extract this hidden information.
This function has \code{option}s which are quite specific as to what they
do.  The user can easily write new options and incorporate them.
This function can be called multiple times
using different options to gradually modify the \code{HivePlotData} object.
}
\details{
\code{option = "rad <- tot.edge.count"} This option looks through the
\code{HivePlotData} object and determines how many edges start or end on
each node (the "degree").  This value is then assigned to the radius for
that node.

\code{option = "axis <- source.man.sink"} This option
examines the nodes and corresponding edges in a \code{HivePlotData} object
to determine if the node is a source, manager or sink.  A source node only
has outgoing edges.  A sink node only has incoming edges.  A manager has
both.  Hence, this option treats the \code{HivePlotData} object as if it
were directed in that the first node of an edge in will be in
\code{HPD$nodes$id1} and the second node of an edge will be in
\code{HPD$nodes$id2}.  As a result, this option produces a hive plot with 3
axes (note: sources are on axis 1, sinks on axis 2, and managers on axis 3).
This concept is similar to the idea of \code{\link[FuncMap]{FuncMap}} but
the internals are quite different.  See also \code{\link{dot2HPD}} for some
details about processing .dot files in an agnostic fashion.

\code{option = "remove orphans"} removes nodes that have degree zero (no
incoming or outgoing edges).

\code{option = "remove zero edge"}
removes edges with length zero.  Such edges cause an error because
the spline cannot be drawn.  This option combines the next two options.

\code{option = "remove self edge"} removes edges that
start and end on the same node.

\code{option = "remove virtual edge"} removes virtual edges which are
edges which involve different nodes but the nodes happen to be on the
the same axis at the same radius.
}
\seealso{
See the vignette for an example of using this function.  Use
\code{browseVignettes("HiveR")} to produce the vignette.
}
\author{
Bryan A. Hanson, DePauw University. \email{hanson@depauw.edu}
}
\keyword{utilities}
