% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/update.HydeNetwork.R
\name{update.HydeNetwork}
\alias{update.HydeNetwork}
\title{Update Probabilistic Graphical Network}
\usage{
\method{update}{HydeNetwork}(object, formula, ...)
}
\arguments{
\item{object}{A \code{HydeNetwork} object}

\item{formula}{A formula statement indicating the changes to the network.}

\item{...}{Additional arguments to be passed to other methods.  Current,
  none are used.}
}
\description{
Add or remove nodes or add parents within a \code{HydeNetwork}
  model.
}
\details{
Adding or removing nodes is fairly straightforward if you are
  removing a complete node (along with its parents).  If you just wish to
  remove a parent, this doesn't work well yet.  I will have to work out
  a solution to remove parent relationships individually.  I had hoped
  there would be an \code{update.dag} method, but no luck.  This will continue
  to be developed in the future, but the arguments will remain the same.
}
\examples{
data(PE, package="HydeNet")
Net <- HydeNetwork(~ wells +
                     pe | wells +
                     d.dimer | pregnant*pe +
                     angio | pe +
                     treat | d.dimer*angio +
                     death | pe*treat)

plot(Net)

Net <- update(Net, . ~ . - pregnant)
plot(Net)
}
\author{
Jarrod Dalton and Benjamin Nutter
}

