% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hydro3Stats.R
\name{GetTfromQ}
\alias{GetTfromQ}
\title{Get return period from value}
\usage{
GetTfromQ(q, H3, options = options_def)
}
\arguments{
\item{q}{numeric, value}

\item{H3}{list, resulting from a call to Hydro3_Estimation()}

\item{options}{list, see ?Hydro3_Estimation}
}
\value{
A list with the following components:
    \item{RP}{numeric, return period}
    \item{IC}{numeric vector, uncertainty interval}
}
\description{
Compute the return period associated with a value from the results of Hydro3_Estimation()
}
\examples{
y=stats::rnorm(50)
H3=Hydro3_Estimation(y,'Normal')
GetTfromQ(3,H3)
}
