% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IBCF.R
\name{IBCF}
\alias{IBCF}
\title{IBCF: Item Based Collaborative Filtering}
\usage{
IBCF(object, dec = 4)
}
\arguments{
\item{object}{\code{list} CrossValidation object, is obtained from CV.RandomPartition function.}

\item{dec}{\code{integer} Number of decimals to print in the results.}
}
\value{
A list with the next components
\item{NPartitions}{\code{integer} Number of partitions used for testing data}
\item{predictions_Summary}{\code{data.frame} A data.frame with the results of the test}
\item{Predictions}{\code{list} A list with the predicted results for each partition}
}
\description{
Item Based Collaborative Filtering for multi-trait and multi-environment data.
}
\examples{
 \dontrun{
  library(IBCF.MTME)
  data('Wheat_IBCF')

  CV <- CV.RandomPart(Wheat_IBCF)
  IBCF(CV)
}

}
