% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events.R
\name{mk_event_poisson}
\alias{mk_event_poisson}
\title{Creates Poisson class event.}
\usage{
mk_event_poisson(type, name, intensity, kernel_code = "")
}
\arguments{
\item{type}{Must be one of \code{'birth'}, \code{'death'}, \code{'entry'}, \code{'exit'}, \code{'swap'} or \code{'custom'}. See details.}

\item{name}{\emph{(Optional)} If not specified, the name given to the event is its type.}

\item{intensity}{String containing some constant positive value, or name of a parameter which is a constant positive value.}

\item{kernel_code}{String containing some C++ code describing the event action. Optional for \code{'birth'}, \code{'death'} and \code{'exit'} events. See details.}
}
\value{
An S3 object of class \code{event} of type Poisson.
}
\description{
The function \code{mk_event_poisson} is used to create an event with intensity of type Poisson (constant intensity which does not depend on population or time).
When the event occurs, something happens in the population.
The created event must be used with \code{\link{mk_model}}.
}
\details{
The \code{type} argument is one of the following
\describe{
\item{\code{'birth'}}{By default, a new individual \code{newI} is created, with the same characteristics of the parent \code{I} and birth date equal to the current time. Optional code can be precised in \code{kernel_code}.}
\item{\code{'death'}}{By default, the individual \code{I} dies. Optional code can be precised in \code{kernel_code}.}
\item{\code{'entry'}}{A new individual \code{newI} is added to the population, and its characteristics have to be defined by the user in the entry \code{kernel_code}.}
\item{\code{'exit'}}{An individual \code{I} exits from the population. Optional code can be precised in \code{kernel_code}.}
\item{\code{'swap'}}{The user can change the caracteristics of the selected individual \code{I}. This requires \code{kernel_code}.}
\item{\code{'custom'}}{None of the above types, the user defines \code{kernel_code} that can act on the selected individual \code{I} and on the population \code{pop}.}
}

The \code{kernel_code} argument is a string containing some C++ code which describing the action of the event. Some of available variables in the C++ code are: \code{t} (the current time), \code{pop} (the current population), \code{I} (the current individual selected for the event), \code{newI} (the new indivudal if \code{'birth'} or \code{'entry'} event), the name of the model parameters (some variables, or functions, see \code{\link{mk_model}}).
See \code{vignette('IBMPopSim')} for more details.
}
\examples{
birth <- mk_event_poisson('birth', intensity = 10)

\donttest{
params <- list(beta = 10)
death <- mk_event_poisson('death', intensity = 'beta') # name of one parameter
mk_model(events = list(birth, death), parameters = params)
}

}
\seealso{
See also \code{\link{mk_model}}, \code{\link{mk_event_inhomogeneous_poisson}}, \code{\link{mk_event_individual}}, \code{\link{mk_event_interaction}}.
}
