% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{FIM_power_logistic}
\alias{FIM_power_logistic}
\title{Fisher Information Matrix for the Power Logistic Model}
\usage{
FIM_power_logistic(x, w, param, s)
}
\arguments{
\item{x}{Vector of design points.}

\item{w}{Vector of design weight. Its length must be equal to the length of \code{x} and \code{sum(w) = 1}.}

\item{param}{Vector of values for the model parameters \code{c(a, b)}.}

\item{s}{parameter \code{s}.}
}
\value{
Fisher information matrix.
}
\description{
It provides the cpp function for FIM for the model  \code{~1/(1 + exp(-b *(x - a)))^s}, but when \code{s} is fixed (a two by two matrix).
}
\note{
This matrix is a two by two matrix and not equal to the Fisher information matrix for the power logistic model
when the derivative is taken with respect to all the three parameters.
This matrix is only given to be used in some illustrative examples.
}
