% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICS_S3.R
\name{gen_kurtosis}
\alias{gen_kurtosis}
\alias{gen_kurtosis.ICS}
\title{To extract the Generalized Kurtosis Values of the ICS Transformation}
\usage{
gen_kurtosis(object, ...)

\method{gen_kurtosis}{ICS}(object, select = NULL, scale = FALSE, index = NULL, ...)
}
\arguments{
\item{object}{an object inheriting from class \code{"ICS"} containing
results from an ICS transformation.}

\item{\dots}{additional arguments to be passed down.}

\item{select}{an integer, character, or logical vector specifying for which
components to extract the generalized kurtosis values, or \code{NULL} to
extract the generalized kurtosis values of all components.}

\item{scale}{a logical indicating whether to scale the generalized kurtosis
values to have product 1 (default to \code{FALSE}). See \sQuote{Details}
for more information.}

\item{index}{an integer vector specifying for which components to extract
the generalized kurtosis values, or \code{NULL} to extract the generalized
kurtosis values of all components.  Note that \code{index} is deprecated
and may be removed in the future, use \code{select} instead.}
}
\value{
A numeric vector containing the generalized kurtosis values of the
requested components.
}
\description{
Extracts the generalized kurtosis values of the components obtained via an
ICS transformation.
}
\details{
The argument \code{scale} is useful when ICS is performed with shape
matrices rather than true scatter matrices. Let \eqn{S_{1}}{S1} and
\eqn{S_{2}}{S2} denote the scatter or shape matrices used in ICS.

If both \eqn{S_{1}}{S1} and \eqn{S_{2}}{S2} are true scatter matrices, their
order in principal does not matter. Changing their order will just reverse
the order of the components and invert the corresponding generalized
kurtosis values.

The same does not hold when at least one of them is a shape matrix rather
than a true scatter matrix. In that case, changing their order will also
reverse the order of the components, but the ratio of the generalized
kurtosis values is no longer 1 but only a constant. This is due to the fact
that when shape matrices are used, the generalized kurtosis values are only
relative ones. It is then useful to scale the generalized kurtosis values
such that their product is 1.
}
\examples{
data("iris")
X <- iris[,-5]
out <- ICS(X)
gen_kurtosis(out)
gen_kurtosis(out, scale = TRUE)
gen_kurtosis(out, select = c(1,4))

}
\seealso{
\code{\link{ICS}()}

\code{\link[=coef.ICS]{coef}()}, \code{\link{components}()},
\code{\link[=fitted.ICS]{fitted}()}, and \code{\link[=plot.ICS]{plot}()}
methods
}
\author{
Andreas Alfons and Aurore Archimbaud
}
