% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICS_S3.R
\name{print.ICS-S3}
\alias{print.ICS-S3}
\alias{print.ICS}
\title{Basic information of ICS Object}
\usage{
\method{print}{ICS}(x, info = FALSE, digits = 4L, ...)
}
\arguments{
\item{x}{object of class \code{ICS}.}

\item{info}{Logical, either TRUE or FALSE. If TRUE, print additional
information on arguments used for computing scatter matrices
(only named arguments that contain numeric, character, or logical scalars)
and information on the parameters of the algorithm.
Default is FALSE.}

\item{digits}{number of digits for the numeric output.}

\item{...}{additional arguments passed to \code{print()}}
}
\description{
Prints information of an \code{ICS} object.
}
\examples{
data("iris")
X <- iris[,-5]
out <- ICS(X)
print(out)
print(out, info = TRUE)
}
\seealso{
\code{\link{ICS}()}
}
\author{
Andreas Alfons and Aurore Archimbaud
}
