% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common_human_and_mouse_ids.R
\name{convert_hm_genes}
\alias{convert_hm_genes}
\title{Convert Human/Mouse Gene IDs between Ensembl and Hugo Symbol System}
\usage{
convert_hm_genes(
  IDs,
  type = c("ensembl", "symbol"),
  genome_build = c("hg38", "hg19", "mm10", "mm9"),
  multiple = FALSE
)
}
\arguments{
\item{IDs}{a character vector to convert.}

\item{type}{type of input \code{IDs}, could be 'ensembl' or 'symbol'.}

\item{genome_build}{reference genome build.}

\item{multiple}{if \code{TRUE}, return a \code{data.table} instead of a string vector,
so multiple identifier mappings can be kept.}
}
\value{
a vector or a \code{data.table}.
}
\description{
Convert Human/Mouse Gene IDs between Ensembl and Hugo Symbol System
}
\examples{
\donttest{
convert_hm_genes("ENSG00000243485")
convert_hm_genes("ENSG00000243485", multiple = TRUE)
convert_hm_genes(c("TP53", "KRAS", "EGFR", "MYC"), type = "symbol")
}
}
