% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IDF.R
\name{qgev.d}
\alias{qgev.d}
\title{Quantile function of modified generalized extreme value distribution}
\usage{
qgev.d(p, mu = 0, sigma = 1, xi = 0, theta = 0, eta = 1, d = 1,
  lower.tail = TRUE)
}
\arguments{
\item{p}{Vector of probabilities}

\item{mu}{location value}

\item{sigma}{scale value}

\item{xi}{shape value}

\item{theta}{value defining the curvature of the IDF}

\item{eta}{value defining the slope of the IDF}

\item{d}{vector of durations}

\item{lower.tail}{\code{logical} if TRUE (default), probabilities are P[X <= x], otherwise, P[X > x]}
}
\value{
qgev.d gives the quantile function
}
\description{
The function \code{qgev.d} is a modified version of the function \code{qgev} for different durations \code{d} developed by Koutsoyiannis et al. (1998).
}
\author{
Christoph Ritschel \email{christoph.ritschel@met.fu-berlin.de}
}
\seealso{
\code{\link[evd]{qgev}}
}

