% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qs.R
\name{qs}
\alias{qs}
\title{Power of spatial determinant (PSD).}
\usage{
qs(y, xh, location)
}
\arguments{
\item{y}{A numeric vector of a response variable}

\item{xh}{A character variable, a data frame or a matrix of
explanatory variables}

\item{location}{A matrix of spatial locations}
}
\value{
A power of spatial determinant (PSD) value.
}
\description{
Power of spatial determinant (PSD).
}
\examples{
# an explanatory variable
library(GD)
data.disc <- disc(sim$xa, 4, "quantile")
xh <- cut(sim$xa, data.disc$itv, include.lowest = TRUE)
qs(sim$y, xh, location = sim[, c("lo","la")])
# multiple explanatory variables
data <- sim[,4:6]
data.disc <- apply(data, 2, FUN = function(x) disc(x, 4, "quantile"))
xh <- do.call(cbind, lapply(1:ncol(data), function(x)
  data.frame(cut(data[, x], data.disc[[x]]$itv, include.lowest = TRUE))))
names(xh) <- names(data)
qs(sim$y, xh, location = sim[, c("lo","la")])

}
