% Generated by roxygen2 (4.0.2): do not edit by hand
\name{get.tau.typed.bootstrap}
\alias{get.tau.typed.bootstrap}
\title{runs bootstrapping for \code{get.tau.typed}}
\usage{
get.tau.typed.bootstrap(posmat, typeA = -1, typeB = -1, r = 1,
  r.low = rep(0, length(r)), boot.iter, comparison.type = "representative")
}
\arguments{
\item{posmat}{a matrix with columns type, x and y}

\item{typeA}{the "from" type that we are interested in, -1 is wildcard}

\item{typeB}{the "to" type that we are interested i, -1 is wildcard}

\item{r}{the series of spatial distances we are interested in}

\item{r.low}{the low end of each range....0  by default}

\item{boot.iter}{the number of bootstrap iterations}

\item{comparison.type}{what type of points are included in the comparison set.
\itemize{
  \item "representative" if comparison set is representative of the underlying population
  \item "independent" if comparison set is cases/events coming from an independent process
}}
}
\value{
tau values for all the distances we looked at
}
\description{
runs bootstrapping for \code{get.tau.typed}
}
\examples{
\dontrun{
 R/examples/get_tau_typed_bootstrap.R
 }
}
\author{
Justin Lessler and Henrik Salje
}
\seealso{
Other get.tau: \code{\link{get.tau.bootstrap}};
  \code{\link{get.tau.ci}}; \code{\link{get.tau.permute}};
  \code{\link{get.tau.typed.permute}};
  \code{\link{get.tau.typed}}; \code{\link{get.tau}}
}

