% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getInfo.R
\name{getInfo}
\alias{getInfo}
\title{IFC File Information Extraction}
\usage{
getInfo(
  fileName,
  from = c("acquisition", "analysis")[2],
  verbose = FALSE,
  verbosity = 1,
  warn = TRUE,
  force_default = TRUE,
  cifdir = dirname(fileName),
  ntry = +Inf,
  ...
)
}
\arguments{
\item{fileName}{path to file..}

\item{from}{whether to extract information from 'acquisition' or 'analysis'. Default is 'analysis'.}

\item{verbose}{whether to display information (use for debugging purpose). Default is FALSE.}

\item{verbosity}{quantity of information print to console when verbose is TRUE; 1: normal, 2: rich. Default is 1.}

\item{warn}{whether to send warning message when trying to read 'analysis' information from a 'rif' file. Default is TRUE.}

\item{force_default}{when display information can't be retrieved whether to use default values. Default is TRUE.}

\item{cifdir}{the path of the directory to initially look to cif file. Default is dirname(fileName). Only apply when 'fileName' is a .daf file.}

\item{ntry}{number of times \code{\link{getInfo}} will be allowed to find corresponding cif file. Default is +Inf. Only apply when 'fileName' is a .daf file.
If cif can't be found, but 'ntry' is reached, then an error will be thrown.}

\item{...}{other arguments to be passed.}
}
\value{
a list of information (open .daf file in an text editor for more details) about input fileName of class `IFC_info` and `acquistion` or `analysis`, whose members are:\cr
-objcount, number of object in file,\cr
-date, date of file creation,\cr
-instrument, instrument identification,\cr
-sw_raw, version of software for raw data,\cr
-sw_processed, version of software for processed data,\cr
-channelwidth, default channel width in pixel,\cr
-in_use, channels used,\cr
-brightfield, whether brightfield is applied on channels and its intensity,\cr
-illumination, laser illumination parameters,\cr
-collectionmode, the collection mode,\cr
-magnification, magnification used,\cr
-coremode, the core mode,\cr
-evmode, the high gain mode,\cr
-CrossTalkMatrix. compensation matrix applied,\cr
-ChannelPresets, channel preset,\cr
-ImageDisplaySettings, image display settings,\cr
-Images, information about colors, range and channels,\cr
-masks, masks defined,\cr
-ViewingModes, modes of visualization,\cr
-checksum, checksum computed,\cr
-Merged_rif, character vector of path of files used to create rif, if input file was a merged,\cr
-Merged_cif, character vector of path of files used to create cif, if input file was a merged,\cr
-XIF_test, integer defining XIF type,\cr
-checksum, integer corresponding to file checksum,\cr
-fileName, path of fileName input,\cr
-fileName_image, path of fileName_image.
}
\description{
Retrieves rich information from RIF, CIF and DAF files.
}
\examples{
if(requireNamespace("IFCdata", quietly = TRUE)) {
  ## use a daf file
  file_daf <- system.file("extdata", "example.daf", package = "IFCdata")
  info <- getInfo(fileName = file_daf, from = "analysis")
  ## show some information
  print(info$Images)
} else {
  message(sprintf('Please run `install.packages("IFCdata", repos = "\%s", type = "source")` \%s',
                  'https://gitdemont.github.io/IFCdata/',
                  'to install extra files required to run this example.'))
}
}
