% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeXIF.R
\name{mergeXIF}
\alias{mergeXIF}
\title{RIF/CIF File Merging}
\usage{
mergeXIF(
  fileName,
  write_to,
  extract_features = FALSE,
  endianness = .Platform$endian,
  verbose = FALSE,
  verbosity = 1,
  overwrite = FALSE,
  display_progress = TRUE,
  add_tracking = TRUE,
  ...
)
}
\arguments{
\item{fileName}{paths of files to merge.
All files have to be either '.rif' or '.cif' files.
All files should have same channels.}

\item{write_to}{pattern used to export file.
Placeholders, like "\%d/\%s_fromR.\%e", will be substituted:\cr
-\%d: with full path directory of first element of 'fileName'\cr
-\%p: with first parent directory of first element of 'fileName'\cr
-\%e: with extension of 'fileName' (without leading .)\cr
-\%s: with shortname from of first element of 'fileName' (i.e. basename without extension).\cr
Exported file extension will be deduced from this pattern. It has to be the same as 'fileName', i.e. .cif or .rif.}

\item{extract_features}{whether to try to extract features. Default is FALSE. Not yet implemented.}

\item{endianness}{the endian-ness ("big" or "little") of the target system for the file. Default is .Platform$endian.\cr
Endianness describes the bytes order of data stored within the files. This parameter may not be modified.}

\item{verbose}{whether to display information (use for debugging purpose). Default is FALSE.}

\item{verbosity}{quantity of information displayed when verbose is TRUE; 1: normal, 2: rich. Default is 1.}

\item{overwrite}{whether to overwrite file or not. Default is FALSE.\cr
Note that if TRUE, it will overwrite exported file if paths of files in 'fileName' and deduced from 'write_to' arguments are different.
Otherwise, you will get an error saying that overwriting source file is not allowed.\cr
Note also that an original file, i.e. generated by IDEAS(R) or INSPIRE(R), will never be overwritten.
Otherwise, you will get an error saying that overwriting original file is not allowed.\cr}

\item{display_progress}{whether to display a progress bar. Default is TRUE.}

\item{add_tracking}{whether to register files' paths and objects' ids in the exported file. Default is TRUE.}

\item{...}{other arguments to be passed.}
}
\value{
It invisibly returns full path of exported file.
}
\description{
Merges RIF or CIF files.
}
\keyword{internal}
